<?php
class User extends Standard {
	protected $id = 0;
	protected $info = array();
	
	public function __construct($id = null){
		parent::__construct();
		if($id !== null){
  		$id = (int) $id;
  		$this->set_info(current($this->db->select(
  			array(), array("users"), '*', array('goperator' => 'and', array("id", "=", $id))
  		)));
		}
	}
  
  /**
   * Checks whether user was loaded successfuly 
   */
  public function is_correct(){
    return !empty($this->id);
  }
  
  public function get_id(){
    return $this->id;
  }
  
  public function get_info($login_info = false){
    $result = $this->info;
    if(!$login_info){
      if(isset($result['login'])) unset($result['login']);
      if(isset($result['pass'])) unset($result['pass']);
    }
    return $result;
  }
  
	protected function set_info($info){
		$this->id = (int) $info['id'];
		$this->info = (array) $info;
	}
}
?>